<?php
/* --------------------------------------------------------------
 HubLoadLayoutDataHandler.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace GXModules\Gambio\Hub\Admin\Plugin;

use Gambio\Admin\Layout\Smarty\LoadLayoutData;

/**
 * Class HubLoadLayoutDataHandler
 * @package GXModules\Gambio\Hub\Admin\Plugin
 */
class HubLoadLayoutDataHandler
{
    /**
     * @var HubFooterBadgeLoader
     */
    private $footerBadgeLoader;
    
    
    /**
     * HubLoadLayoutDataHandler constructor.
     *
     * @param HubFooterBadgeLoader $footerBadgeLoader
     */
    public function __construct(HubFooterBadgeLoader $footerBadgeLoader)
    {
        $this->footerBadgeLoader = $footerBadgeLoader;
    }
    
    
    /**
     * Adds the hub footer layout loader.
     *
     * @param LoadLayoutData $command
     *
     * @return LoadLayoutData
     */
    public function __invoke(LoadLayoutData $command): LoadLayoutData
    {
        $command->addLoader($this->footerBadgeLoader);
        
        return $command;
    }
}